#!/bin/bash

# Shopify Integration - Deployment & Cache Clear Script
# Run this after uploading files to your hosting

echo "🚀 Deploying Shopify Integration..."
echo ""

# Clear all Laravel caches
echo "📦 Clearing configuration cache..."
php artisan config:clear

echo "🛣️  Clearing route cache..."
php artisan route:clear

echo "💾 Clearing application cache..."
php artisan cache:clear

echo "👁️  Clearing view cache..."
php artisan view:clear

echo "🔄 Clearing compiled classes..."
php artisan clear-compiled

echo ""
echo "✅ Cache cleared successfully!"
echo ""

# Optional: Run migrations
read -p "Do you want to run database migrations? (y/n) " -n 1 -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]
then
    echo "📊 Running migrations..."
    php artisan migrate --force
    echo "✅ Migrations completed!"
fi

echo ""
echo "🎉 Deployment complete!"
echo ""
echo "You can now access:"
echo "  - Shopify Settings: /dashboard/user/marketing-bot/shopify/settings"
echo "  - Dashboard Customization: /dashboard/user/marketing-bot/dashboard/customize"
echo ""
